package org.msh.tb.reports2.variables;

import org.msh.reports.filters.FilterOperation;
import org.msh.reports.filters.ValueHandler;
import org.msh.reports.query.SQLDefs;
import org.msh.tb.entities.enums.TbField;

/**
 * Created by rmemoria on 15/12/16.
 */
public class FieldValueNGVariable extends FieldValueVariable {

    public FieldValueNGVariable(String id, String keylabel, String fieldName, TbField tbfield) {
        super(id, keylabel, fieldName, tbfield);
    }

    @Override
    public void prepareVariableQuery(SQLDefs def, int iteration) {
        def.join("tbcaseng", "id", "tbcase", "id");
        super.prepareVariableQuery(def, iteration);
    }

    @Override
    public void prepareFilterQuery(SQLDefs def, FilterOperation oper, ValueHandler value) {
        def.join("tbcaseng", "id", "tbcase", "id");
        super.prepareFilterQuery(def, oper, value);
    }
}
